<?php 
include("includes/db_helper.php");
include("includes/lb_helper.php"); 
include("language/api_language.php"); 
include("smtp_email.php");

error_reporting(0);

$file_path = getBaseUrl();

$mysqli->set_charset('utf8mb4');

date_default_timezone_set("Asia/Colombo");

define("DEFAULT_PASSWORD",'123');
define("PACKAGE_NAME",$settings_details['envato_package_name']);

// For Api header
$API_NAME = 'NEMOSOFTS_APP';

// Purchase code verification
if($settings_details['envato_buyer_name']=='' OR $settings_details['envato_purchase_code']=='' OR $settings_details['envato_api_key']=='') {
    $set[$API_NAME][]=array('MSG'=> 'Purchase code verification failed!','success'=>'0');
	header( 'Content-Type: application/json; charset=utf-8' );
	echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}

// Generate random password
function generateRandomPassword($length = 10) {
	$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$charactersLength = strlen($characters);
	$randomString = '';
	for ($i = 0; $i < $length; $i++) {
		$randomString .= $characters[rand(0, $charactersLength - 1)];
	}
	return $randomString;
}

function update_activity_log($user_id){
	global $mysqli;
    
    $sql="SELECT * FROM tbl_active_log WHERE `user_id`='$user_id'";
    $result=mysqli_query($mysqli, $sql);
    
    if(mysqli_num_rows($result) == 0){
        
        $data_log = array('user_id'  =>  $user_id, 'date_time'  =>  strtotime(date('d-m-Y h:i:s A')));
        $qry = Insert('tbl_active_log',$data_log);
    } else {
        
        $data_log = array('date_time'  =>  strtotime(date('d-m-Y h:i:s A')));
        $update=Update('tbl_active_log', $data_log, "WHERE user_id = '$user_id'");  
    }
    
    mysqli_free_result($result);
}
function send_register_email($to, $recipient_name, $subject, $message){	
	global $file_path;
    global $app_lang;

	$message_body='<div style="background-color: #eee;" align="center"><br />
	<table style="font-family: OpenSans,sans-serif; color: #666666;" border="0" width="600" cellspacing="0" cellpadding="0" align="center" bgcolor="#FFFFFF">
	<tbody>
	<tr>
	<td colspan="2" bgcolor="#FFFFFF" align="center" ><img src="'.$file_path.'images/'.APP_LOGO.'" alt="logo" style="width:100px;height:auto"/></td>
	</tr>
	<br>
	<br>
	<tr>
	<td colspan="2" bgcolor="#FFFFFF" align="center" style="padding-top:25px;">
	<img src="'.$file_path.'assets/images/thankyoudribble.gif" alt="header" auto-height="100" width="50%"/>
	</td>
	</tr>
	<tr>
	<td width="600" valign="top" bgcolor="#FFFFFF">
	<table style="font-family:OpenSans,sans-serif; color: #666666; font-size: 10px; padding: 15px;" border="0" width="100%" cellspacing="0" cellpadding="0" align="left">
	<tbody>
	<tr>
	<td valign="top">
	<table border="0" align="left" cellpadding="0" cellspacing="0" style="font-family:OpenSans,sans-serif; color: #666666; font-size: 10px; width:100%;">
	<tbody>
	<tr>
	<td>
	<p style="color: #717171; font-size: 24px; margin-top:0px; margin:0 auto; text-align:center;"><strong>'.$app_lang['welcome_lbl'].', '.$recipient_name.'</strong></p>
	<br>
	<p style="color:#15791c; font-size:18px; line-height:32px;font-weight:500;margin-bottom:30px; margin:0 auto; text-align:center;">'.$message.'<br /></p>
	<br/>
	<p style="color:#999; font-size:17px; line-height:32px;font-weight:500;">'.$app_lang['thank_you_lbl'].' '.APP_NAME.'</p>
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	<tr>
	<td style="color: #262626; padding: 20px 0; font-size: 18px; border-top:5px solid #52bfd3;" colspan="2" align="center" bgcolor="#ffffff">'.$app_lang['email_copyright'].' '.APP_NAME.'.</td>
	</tr>
	</tbody>
	</table>
	</div>';

	send_email($to,$recipient_name,$subject,$message_body);
}

// For favorite
function is_favourite($id,$user_id=''){	
 	global $mysqli;
 	$sql="SELECT * FROM tbl_favourite WHERE `post_id`='$id' AND `user_id`='$user_id'";
 	$result=mysqli_query($mysqli, $sql);
 	if(mysqli_num_rows($result) > 0){
 		return true;
 	} else {
 		return false;
 	}
}

$get_helper = get_api_data($_POST['data']);
if($get_helper['helper_name']=="get_home"){
    
    $home_limit = HOME_LIMIT;
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    $ids=isset($get_helper['radio_ids']) ? trim($get_helper['radio_ids']) : 0;
    
    $jsonObj= array();
	$data_arr= array();
    
    $sql="SELECT * FROM tbl_banner WHERE tbl_banner.status='1' ORDER BY tbl_banner.bid DESC";
    $result = mysqli_query($mysqli, $sql);
    
    while($data = mysqli_fetch_assoc($result)){
        $data_arr['bid'] = $data['bid'];
	    $data_arr['banner_title'] = $data['banner_title'];
	    $data_arr['banner_info'] = $data['banner_info'];
	    $data_arr['banner_image'] = $file_path.'images/'.$data['banner_image'];
        array_push($jsonObj,$data_arr);
    }
    $row['slider'] = $jsonObj;
    
    mysqli_free_result($result);
	$jsonObj = array();
	$data_arr = array();
	
	$sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.`id` IN ($ids) AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.id DESC LIMIT $home_limit";
    $result = mysqli_query($mysqli, $sql);
    while ($data = mysqli_fetch_assoc($result)){
        
        $data_arr['id'] = $data['id'];
	    $data_arr['cat_id'] = $data['cat_id'];
	    $data_arr['radio_title'] = $data['radio_title'];
	    $data_arr['radio_url'] = $data['radio_url'];
	    $data_arr['image'] = $file_path.'images/'.$data['radio_image'];
	    $data_arr['averageRating'] = $data['rate_avg'];
	    $data_arr['totalRate'] = $data['total_rate'];
	    $data_arr['category_name'] = $data['category_name'];
	    $data_arr['total_views'] = $data['total_views'];
	    $data_arr['is_premium'] = $data['isPremium'];
	    $data_arr['is_favourite'] =  is_favourite($data['id'],$user_id);

		array_push($jsonObj, $data_arr);
	}
	$row['recently_radio'] = $jsonObj;

	mysqli_free_result($result);
	$jsonObj = array();
	$data_arr = array();
	
	$sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.id DESC LIMIT $home_limit";
    $result = mysqli_query($mysqli, $sql);
    while ($data = mysqli_fetch_assoc($result)){
        
        $data_arr['id'] = $data['id'];
	    $data_arr['cat_id'] = $data['cat_id'];
	    $data_arr['radio_title'] = $data['radio_title'];
	    $data_arr['radio_url'] = $data['radio_url'];
	    $data_arr['image'] = $file_path.'images/'.$data['radio_image'];
	    $data_arr['averageRating'] = $data['rate_avg'];
	    $data_arr['totalRate'] = $data['total_rate'];
	    $data_arr['category_name'] = $data['category_name'];
	    $data_arr['total_views'] = $data['total_views'];
	    $data_arr['is_premium'] = $data['isPremium'];
	    $data_arr['is_favourite'] =  is_favourite($data['id'],$user_id);

		array_push($jsonObj, $data_arr);
	}
	$row['latest_radio'] = $jsonObj;
	
	
	mysqli_free_result($result);
	$jsonObj = array();
	$data_arr = array();
	
	$sql_views="SELECT *,DATE_FORMAT(`date`, '%m/%d/%Y') FROM `tbl_radio_views` WHERE `date` BETWEEN NOW() - INTERVAL 30 DAY AND NOW() GROUP BY `radio_id` ORDER BY views DESC LIMIT 25";
	$res_views=mysqli_query($mysqli, $sql_views);
	while ($row_views=mysqli_fetch_assoc($res_views)){
	    
	    $id=$row_views['radio_id'];
	    
	    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.status='1' AND tbl_category.`status`=1 AND tbl_radio.`id`='$id' ORDER BY tbl_radio.`id` DESC";
        $result = mysqli_query($mysqli, $sql);
        while ($data = mysqli_fetch_assoc($result)){
            
            $data_arr['id'] = $data['id'];
    	    $data_arr['cat_id'] = $data['cat_id'];
    	    $data_arr['radio_title'] = $data['radio_title'];
    	    $data_arr['radio_url'] = $data['radio_url'];
    	    $data_arr['image'] = $file_path.'images/'.$data['radio_image'];
    	    $data_arr['averageRating'] = $data['rate_avg'];
    	    $data_arr['totalRate'] = $data['total_rate'];
    	    $data_arr['category_name'] = $data['category_name'];
    	    $data_arr['total_views'] = $data['total_views'];
    	    $data_arr['is_premium'] = $data['isPremium'];
    	    $data_arr['is_favourite'] =  is_favourite($data['id'],$user_id);

    		array_push($jsonObj, $data_arr);
    	}
	}
	
	$row['trending_radio'] = $jsonObj;

	mysqli_free_result($res_views);
	$jsonObj = array();
	$data_arr = array();
	
	$sql = "SELECT * FROM tbl_home_sections WHERE status='1' ORDER BY tbl_home_sections.`id` DESC";
	$result = mysqli_query($mysqli, $sql);
	while ($data = mysqli_fetch_assoc($result)){
	    $id_list=explode(",", $data['post_ids']);
      	
      	if($data['section_type']=="category"){
      	    
            foreach($id_list as $ids){
                
                $query01="SELECT * FROM tbl_category WHERE tbl_category.`cid`='$ids' AND tbl_category.status='1' ORDER BY tbl_category.cid DESC LIMIT $home_limit";
				$sql01 = mysqli_query($mysqli,$query01);
				
				if(mysqli_num_rows($sql01) > 0){
				    while($data01 = mysqli_fetch_assoc($sql01)) {
				        $home_content1[]= array(
				            "post_id"=>$data01['cid'],
				            "post_title"=>$data01['category_name'],
				            "post_image"=> $file_path.'images/'.$data01['category_image']
				        );
					}
				}
            }
            
            $row['home_sections'][]=array("home_id"=>$data['id'],"home_title"=>$data['section_name'],"home_type"=>$data['section_type'],"home_content"=>$home_content1);
            unset($home_content1);
      	}
      	
      	else if($data['section_type']=="countries"){
      	    
            foreach($id_list as $cids){
                
                $query02="SELECT * FROM tbl_countries WHERE tbl_countries.`sid`='$cids' ORDER BY tbl_countries.sid DESC LIMIT $home_limit";
				$sql02 = mysqli_query($mysqli,$query02);
				
				if(mysqli_num_rows($sql02) > 0){
				    while($data02 = mysqli_fetch_assoc($sql02)) {
				        $home_content2[]= array(
				            "post_id"=>$data02['sid'],
				            "post_title"=>$data02['countries_name'],
				            "post_image"=> $file_path.'images/'.$data02['countries_image']
				        );
					}
				}
            }
            
            $row['home_sections'][]=array("home_id"=>$data['id'],"home_title"=>$data['section_name'],"home_type"=>$data['section_type'],"home_content"=>$home_content2);
            unset($home_content2);
      	}
      	
      	else if($data['section_type']=="podcasts"){
      	    
            foreach($id_list as $alids){
                
                $query03="SELECT * FROM tbl_podcast WHERE tbl_podcast.`pid`='$alids' ORDER BY tbl_podcast.pid DESC LIMIT $home_limit";
				$sql03 = mysqli_query($mysqli,$query03);
				
				if(mysqli_num_rows($sql03) > 0){
				    while($data03 = mysqli_fetch_assoc($sql03)) {
				        $home_content3[]= array(
				            "post_id"=>$data03['pid'],
				            "post_title"=>$data03['podcast_name'],
				            "post_image"=> $file_path.'images/'.$data03['podcast_image']
				        );
					}
				}
            }
            
            $row['home_sections'][]=array("home_id"=>$data['id'],"home_title"=>$data['section_name'],"home_type"=>$data['section_type'],"home_content"=>$home_content3);
            unset($home_content3);
      	}
      	
      	else if($data['section_type']=="radio"){
      	    
            foreach($id_list as $sids){
                
                $query05="SELECT * FROM tbl_radio
                    LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
                    WHERE tbl_radio.`id` ='$sids' AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.`id` DESC LIMIT $home_limit";
				$sql05 = mysqli_query($mysqli,$query05);
				
				if(mysqli_num_rows($sql05) > 0){
				    while($data05 = mysqli_fetch_assoc($sql05)) {
				        
				        $data_arr['id'] = $data05['id'];
                	    $data_arr['cat_id'] = $data05['cat_id'];
                	    $data_arr['radio_title'] = $data05['radio_title'];
                	    $data_arr['radio_url'] = $data05['radio_url'];
                	    $data_arr['image'] = $file_path.'images/'.$data05['radio_image'];
                	    $data_arr['averageRating'] = $data05['rate_avg'];
                	    $data_arr['totalRate'] = $data05['total_rate'];
                	    $data_arr['category_name'] = $data05['category_name'];
                	    $data_arr['total_views'] = $data05['total_views'];
                	    $data_arr['is_premium'] = $data05['isPremium'];
                	    $data_arr['is_favourite'] =  is_favourite($data05['id'],$user_id);

                		array_push($jsonObj, $data_arr);
					}
				}
            }
            
            $row['home_sections'][]=array("home_id"=>$data['id'],"home_title"=>$data['section_name'],"home_type"=>$data['section_type'],"home_content"=>$jsonObj);
            unset($jsonObj);
      	}
	}
	
    $set[$API_NAME] = $row;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="home_collections"){
    
    $user_id=isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
    $sections_id=isset($get_helper['id']) ? trim($get_helper['id']) : 0;
    
	$jsonObj = array();
	$data_arr = array();
	
	$sql = "SELECT * FROM tbl_home_sections WHERE tbl_home_sections.`id`='$sections_id' AND status='1' ORDER BY tbl_home_sections.`id` DESC";
	$result = mysqli_query($mysqli, $sql);
	while ($data = mysqli_fetch_assoc($result)){
	    
	    $id_list=explode(",", $data['post_ids']);
	    
      	if($data['section_type']=="category"){

            foreach($id_list as $ids){
                
                $query01="SELECT * FROM tbl_category WHERE tbl_category.`cid`='$ids' AND tbl_category.status='1' ORDER BY tbl_category.cid DESC";
				$sql01 = mysqli_query($mysqli,$query01);
				
				if(mysqli_num_rows($sql01) > 0){
				    while($data01 = mysqli_fetch_assoc($sql01)) {
				        
				        $data_arr['cid'] = $data01['cid'];
                		$data_arr['category_name'] = $data01['category_name'];
                		$data_arr['category_image'] = $file_path.'images/'.$data01['category_image'];
                		
				        array_push($jsonObj, $data_arr);
					}
				}
            }
      	}
      	
      	else if($data['section_type']=="countries"){

            foreach($id_list as $cids){
                
                $query02="SELECT * FROM tbl_countries WHERE tbl_countries.`sid`='$cids' ORDER BY tbl_countries.sid DESC";
				$sql02 = mysqli_query($mysqli,$query02);
				
				if(mysqli_num_rows($sql02) > 0){
				    while($data02 = mysqli_fetch_assoc($sql02)) {
				        
				        $data_arr['cid'] = $data02['sid'];
                        $data_arr['countries_name'] = $data02['countries_name'];
                        $data_arr['countries_image'] = $file_path.'images/'.$data02['countries_image'];
                        
				        array_push($jsonObj, $data_arr);
					}
				}
            }
      	}
      	
      	else if($data['section_type']=="podcasts"){

            foreach($id_list as $alids){
                
                $query03="SELECT * FROM tbl_podcast WHERE tbl_podcast.`pid`='$alids' ORDER BY tbl_podcast.pid DESC";
				$sql03 = mysqli_query($mysqli,$query03);
				
				if(mysqli_num_rows($sql03) > 0){
				    while($data03 = mysqli_fetch_assoc($sql03)) {
				        
				        $data_arr['pid'] = $data03['pid'];
                        $data_arr['podcast_name'] = $data03['podcast_name'];
                        $data_arr['podcast_image'] = $file_path.'images/'.$data03['podcast_image'];
                        
				        array_push($jsonObj, $data_arr);
					}
				}
                
            }
      	}
      	
      	else if($data['section_type']=="radio"){
      	    
            foreach($id_list as $sids){
                
                $query04="SELECT * FROM tbl_radio
                    LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
                    WHERE tbl_radio.`id` ='$sids' AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.`id` DESC ";
				$sql04 = mysqli_query($mysqli,$query04);
				
				if(mysqli_num_rows($sql04) > 0){
				    while($data04 = mysqli_fetch_assoc($sql04)) {
				        
				        $data_arr['id'] = $data04['id'];
                	    $data_arr['cat_id'] = $data04['cat_id'];
                	    $data_arr['radio_title'] = $data04['radio_title'];
                	    $data_arr['radio_url'] = $data04['radio_url'];
                	    $data_arr['image'] = $file_path.'images/'.$data04['radio_image'];
                	    $data_arr['averageRating'] = $data04['rate_avg'];
                	    $data_arr['totalRate'] = $data04['total_rate'];
                	    $data_arr['category_name'] = $data04['category_name'];
                	    $data_arr['total_views'] = $data04['total_views'];
                	    $data_arr['is_premium'] = $data04['isPremium'];
                	    $data_arr['is_favourite'] =  is_favourite($data04['id'],$user_id);
                	    
				        array_push($jsonObj, $data_arr);
					}
				}
                
            }
      	}
      	
	}
    $set[$API_NAME] = $jsonObj;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="get_latest"){
    
    $jsonObj= array();
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    
    $page_limit=10;
    $limit=($get_helper['page']-1) * $page_limit;
    
    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.id DESC LIMIT $limit, $page_limit";
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        
        $row['id'] = $data['id'];
	    $row['cat_id'] = $data['cat_id'];
	    $row['radio_title'] = $data['radio_title'];
	    $row['radio_url'] = $data['radio_url'];
	    $row['image'] = $file_path.'images/'.$data['radio_image'];
	    $row['averageRating'] = $data['rate_avg'];
	    $row['totalRate'] = $data['total_rate'];
	    $row['category_name'] = $data['category_name'];
	    $row['total_views'] = $data['total_views'];
	    $row['is_premium'] = $data['isPremium'];
	    $row['is_favourite'] =  is_favourite($data['id'],$user_id);
	    
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="get_trending_radio"){
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;

    $jsonObj = array();
	$data_arr = array();
	
	$sql_views="SELECT *,DATE_FORMAT(`date`, '%m/%d/%Y') FROM `tbl_radio_views` WHERE `date` BETWEEN NOW() - INTERVAL 30 DAY AND NOW() GROUP BY `radio_id` ORDER BY views DESC LIMIT 25";
	$res_views=mysqli_query($mysqli, $sql_views);
	while ($row_views=mysqli_fetch_assoc($res_views)){
	    
	    $id=$row_views['radio_id'];
	    
	    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.status='1' AND tbl_category.`status`=1 AND tbl_radio.`id`='$id' ORDER BY tbl_radio.`id` DESC";
        $result = mysqli_query($mysqli, $sql);
        
        while ($data = mysqli_fetch_assoc($result)){
            
            $data_arr['id'] = $data['id'];
    	    $data_arr['cat_id'] = $data['cat_id'];
    	    $data_arr['radio_title'] = $data['radio_title'];
    	    $data_arr['radio_url'] = $data['radio_url'];
    	    $data_arr['image'] = $file_path.'images/'.$data['radio_image'];
    	    $data_arr['averageRating'] = $data['rate_avg'];
    	    $data_arr['totalRate'] = $data['total_rate'];
    	    $data_arr['category_name'] = $data['category_name'];
    	    $data_arr['total_views'] = $data['total_views'];
    	    $data_arr['is_premium'] = $data['isPremium'];
    	    $data_arr['is_favourite'] =  is_favourite($data['id'],$user_id);

    		array_push($jsonObj, $data_arr);
    	}
	}
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="cat_list"){
    
    $search_text=addslashes(trim($get_helper['search_text']));
    $search_type=trim($get_helper['search_type']);
    
    $jsonObj= array();
    
    $page_limit=15;
    $limit=($get_helper['page']-1) * $page_limit;
    
    if($search_type == 'search'){
        $sql="SELECT * FROM tbl_category WHERE tbl_category.status='1' AND tbl_category.`category_name` like '%$search_text%'
        ORDER BY tbl_category.category_name DESC LIMIT $limit, $page_limit";
    } else {
        $sql="SELECT * FROM tbl_category WHERE tbl_category.status='1' ORDER BY tbl_category.cid DESC LIMIT $limit, $page_limit";
    }
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        
        $row['cid'] = $data['cid'];
        $row['category_name'] = $data['category_name'];
        $row['category_image'] = $file_path.'images/'.$data['category_image'];
        
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="cou_list"){
    
    $search_text=addslashes(trim($get_helper['search_text']));
    $search_type=trim($get_helper['search_type']);
    
    $jsonObj= array();
    
    $page_limit=15;
    $limit=($get_helper['page']-1) * $page_limit;
    
    if($search_type == 'search'){
        $sql="SELECT * FROM tbl_countries WHERE tbl_countries.status='1' AND tbl_countries.`countries_name` like '%$search_text%'
        ORDER BY tbl_countries.countries_name DESC LIMIT $limit, $page_limit";
    } else {
        $sql="SELECT * FROM tbl_countries WHERE tbl_countries.status='1' ORDER BY tbl_countries.sid DESC LIMIT $limit, $page_limit";
    }
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        
        $row['cid'] = $data['sid'];
        $row['countries_name'] = $data['countries_name'];
        $row['countries_image'] = $file_path.'images/'.$data['countries_image'];
        
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="podcasts_list"){
    
    $search_text=addslashes(trim($get_helper['search_text']));
    $search_type=trim($get_helper['search_type']);
    
    $jsonObj= array();
    
    $page_limit=15;
    $limit=($get_helper['page']-1) * $page_limit;
    
    if($search_type == 'search'){
        $sql="SELECT * FROM tbl_podcast WHERE tbl_podcast.status='1' AND tbl_podcast.`podcast_name` like '%$search_text%'
        ORDER BY tbl_podcast.podcast_name DESC LIMIT $limit, $page_limit";
    } else {
        $sql="SELECT * FROM tbl_podcast WHERE tbl_podcast.status='1' ORDER BY tbl_podcast.pid DESC LIMIT $limit, $page_limit";
    }
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        
        $row['pid'] = $data['pid'];
        $row['podcast_name'] = $data['podcast_name'];
        $row['podcast_image'] = $file_path.'images/'.$data['podcast_image'];
        
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="get_recent_radio"){
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    $ids=trim($get_helper['radio_ids']);
    
    $jsonObj= array();
    
    $page_limit=15;
    $limit=($get_helper['page']-1) * $page_limit;
    
    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.`id` IN ($ids) AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.`id` DESC LIMIT $limit, $page_limit";
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        $row['id'] = $data['id'];
	    $row['cat_id'] = $data['cat_id'];
	    $row['radio_title'] = $data['radio_title'];
	    $row['radio_url'] = $data['radio_url'];
	    $row['image'] = $file_path.'images/'.$data['radio_image'];
	    $row['averageRating'] = $data['rate_avg'];
	    $row['totalRate'] = $data['total_rate'];
	    $row['category_name'] = $data['category_name'];
	    $row['total_views'] = $data['total_views'];
	    $row['is_premium'] = $data['isPremium'];
	    $row['is_favourite'] =  is_favourite($data['id'],$user_id);
		
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="single_radio"){
    
    $response=array();
    
    $view_qry = mysqli_query($mysqli, "UPDATE tbl_radio SET total_views = total_views + 1 WHERE id = '" . $get_helper['radio_id'] . "'");
    
    $song_id = $get_helper['radio_id'];
	$date = date('Y-m-d');

	$start = (date('D') != 'Mon') ? date('Y-m-d', strtotime('last Monday')) : date('Y-m-d');
	$finish = (date('D') != 'Sat') ? date('Y-m-d', strtotime('next Saturday')) : date('Y-m-d');
	
	$query = "SELECT * FROM tbl_radio_views WHERE radio_id='$song_id' AND date BETWEEN '$start' AND '$finish'";
	$sql = mysqli_query($mysqli, $query);
	
	if (mysqli_num_rows($sql) > 0) {
		
		$query1 = "UPDATE tbl_radio_views SET views=views+1 WHERE radio_id='$song_id' AND date BETWEEN '$start' AND '$finish'";
		$sql1 = mysqli_query($mysqli, $query1);
		
		$response=array('MSG' => 'update','success'=>'1');
		
	} else {
	    
	    $query2 = "SELECT * FROM tbl_radio_views WHERE radio_id='$song_id'";
	    $sql2 = mysqli_query($mysqli, $query2);
	    if (mysqli_num_rows($sql2) > 0) {
	        $deleteSql = "DELETE FROM tbl_radio_views WHERE `radio_id` IN ($song_id)";
            mysqli_query($mysqli, $deleteSql);
	    }
	    
		$data = array(
			'radio_id'  =>  $song_id,
			'views'  =>  1,
			'date'  =>  $date
		);
		$qry = Insert('tbl_radio_views', $data);
		
		$response=array('MSG' => 'added','success'=>'1');
	}
	$set[$API_NAME][]=$response;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="get_search_radio"){
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    $search_text=addslashes(trim($get_helper['search_text']));
    
    $jsonObj= array();
    
    $page_limit=15;
    $limit=($get_helper['page']-1) * $page_limit;
    
    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.`radio_title` like '%$search_text%' AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.`radio_title` DESC LIMIT $limit, $page_limit";
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        
        $row['id'] = $data['id'];
	    $row['cat_id'] = $data['cat_id'];
	    $row['radio_title'] = $data['radio_title'];
	    $row['radio_url'] = $data['radio_url'];
	    $row['image'] = $file_path.'images/'.$data['radio_image'];
	    $row['averageRating'] = $data['rate_avg'];
	    $row['totalRate'] = $data['total_rate'];
	    $row['category_name'] = $data['category_name'];
	    $row['total_views'] = $data['total_views'];
	    $row['is_premium'] = $data['isPremium'];
	    $row['is_favourite'] =  is_favourite($data['id'],$user_id);
	    
        array_push($jsonObj,$row);
    }
    
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="get_podcasts_by"){

    $jsonObj= array();

    $podcasts_id = cleanInput($get_helper['podcasts_id']);
    
    $page_limit=10;
    $limit=($get_helper['page']-1) * $page_limit;
    
    $sql="SELECT * FROM tbl_episode
            LEFT JOIN tbl_podcast ON tbl_episode.`podcast_id`= tbl_podcast.`pid` 
            WHERE tbl_episode.podcast_id='".$podcasts_id."' AND tbl_episode.status='1' ORDER BY tbl_episode.`id` DESC LIMIT $limit, $page_limit";
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        
        $row['id'] = $data['id'];
        $row['podcast_id'] = $data['podcast_id'];
        $row['episode_title'] = $data['episode_title'];
        $row['episode_url'] = $data['episode_url'];
        $row['podcast_name'] = $data['podcast_name'];
        $row['podcast_image'] = $file_path.'images/'.$data['podcast_image'];
        
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="cat_radio"){
    
    $jsonObj= array();
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    $cat_id = $get_helper['cat_id'];
    
    $page_limit=10;
    $limit=($get_helper['page']-1) * $page_limit;
    
    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.`cat_id`='$cat_id' AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.id DESC LIMIT $limit, $page_limit";
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        
        $row['id'] = $data['id'];
        $row['cat_id'] = $data['cat_id'];
        $row['radio_title'] = $data['radio_title'];
        $row['radio_url'] = $data['radio_url'];
        $row['image'] = $file_path.'images/'.$data['radio_image'];
        $row['averageRating'] = $data['rate_avg'];
        $row['totalRate'] = $data['total_rate'];
        $row['category_name'] = $data['category_name'];
        $row['total_views'] = $data['total_views'];
        $row['is_premium'] = $data['isPremium'];
        $row['is_favourite'] =  is_favourite($data['id'],$user_id);
        
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="cou_radio"){
    
    $jsonObj= array();
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    $cou_id = $get_helper['cou_id'];
    
    $page_limit=10;
    $limit=($get_helper['page']-1) * $page_limit;
    
    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.`countries_id`='$cou_id' AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.id DESC LIMIT $limit, $page_limit";
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        
        $row['id'] = $data['id'];
        $row['cat_id'] = $data['cat_id'];
        $row['radio_title'] = $data['radio_title'];
        $row['radio_url'] = $data['radio_url'];
        $row['image'] = $file_path.'images/'.$data['radio_image'];
        $row['averageRating'] = $data['rate_avg'];
        $row['totalRate'] = $data['total_rate'];
        $row['category_name'] = $data['category_name'];
        $row['total_views'] = $data['total_views'];
        $row['is_premium'] = $data['isPremium'];
        $row['is_favourite'] =  is_favourite($data['id'],$user_id);
        
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="banner_radio"){
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    $banner_id = $get_helper['banner_id'];
    
    $sql_banner="SELECT * FROM tbl_banner WHERE status='1' AND `bid`='$banner_id' ORDER BY tbl_banner.`bid` DESC";
	$res_banner = mysqli_query($mysqli,$sql_banner);
	$row_banner=mysqli_fetch_assoc($res_banner);

	$radio_ids = trim($row_banner['banner_post_id']);

    $jsonObj= array();
    
    $page_limit=15;
    $limit=($get_helper['page']-1) * $page_limit;
    
    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.`id` IN ($radio_ids) AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.id DESC LIMIT $limit, $page_limit";
    $result = mysqli_query($mysqli, $sql);
    while($data = mysqli_fetch_assoc($result)){
        $row['id'] = $data['id'];
        $row['cat_id'] = $data['cat_id'];
        $row['radio_title'] = $data['radio_title'];
        $row['radio_url'] = $data['radio_url'];
        $row['image'] = $file_path.'images/'.$data['radio_image'];
        $row['averageRating'] = $data['rate_avg'];
        $row['totalRate'] = $data['total_rate'];
        $row['category_name'] = $data['category_name'];
        $row['total_views'] = $data['total_views'];
        $row['is_premium'] = $data['isPremium'];
        $row['is_favourite'] =  is_favourite($data['id'],$user_id);
		
        array_push($jsonObj,$row);
    }
    $set[$API_NAME] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="get_search"){
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    $search_text=addslashes(trim($get_helper['search_text']));
    
	$jsonObj = array();
	$data_arr = array();
	
    $sql="SELECT * FROM tbl_radio
        LEFT JOIN tbl_category ON tbl_radio.`cat_id`= tbl_category.`cid` 
        WHERE tbl_radio.`radio_title` like '%$search_text%' AND tbl_radio.status='1' AND tbl_category.`status`=1 ORDER BY tbl_radio.`radio_title` DESC";
    $result = mysqli_query($mysqli, $sql);
    while ($data = mysqli_fetch_assoc($result)){
        
        $data_arr['id'] = $data['id'];
	    $data_arr['cat_id'] = $data['cat_id'];
	    $data_arr['radio_title'] = $data['radio_title'];
	    $data_arr['radio_url'] = $data['radio_url'];
	    $data_arr['image'] = $file_path.'images/'.$data['radio_image'];
	    $data_arr['averageRating'] = $data['rate_avg'];
	    $data_arr['totalRate'] = $data['total_rate'];
	    $data_arr['category_name'] = $data['category_name'];
	    $data_arr['total_views'] = $data['total_views'];
	    $data_arr['is_premium'] = $data['isPremium'];
	    $data_arr['is_favourite'] =  is_favourite($data['id'],$user_id);

		array_push($jsonObj, $data_arr);
	}
	$row['radio_list'] = $jsonObj;


	mysqli_free_result($result);
	$jsonObj = array();
	$data_arr = array();
	
	$sql = "SELECT * FROM tbl_category WHERE tbl_category.`category_name` like '%$search_text%' AND tbl_category.`status`=1 ORDER BY tbl_category.`category_name` DESC";
	$result = mysqli_query($mysqli, $sql);
	while ($data = mysqli_fetch_assoc($result)){
	    
	    $data_arr['post_id'] = $data['cid'];
        $data_arr['post_title'] = $data['category_name'];
        $data_arr['post_image'] = $file_path.'images/'.$data['category_image'];
        
		array_push($jsonObj, $data_arr);
	}
	$row['category_list'] = $jsonObj;
	
	mysqli_free_result($result);
	$jsonObj = array();
	$data_arr = array();

	$sql = "SELECT * FROM tbl_countries WHERE tbl_countries.`countries_name` like '%$search_text%' AND tbl_countries.`status`=1 ORDER BY tbl_countries.`countries_name` DESC";
	$result = mysqli_query($mysqli, $sql);
	while ($data = mysqli_fetch_assoc($result)){
	    
	    $data_arr['post_id'] = $data['sid'];
        $data_arr['post_title'] = $data['countries_name'];
        $data_arr['post_image'] = $file_path.'images/'.$data['countries_image'];
        
		array_push($jsonObj, $data_arr);
	}
	$row['countries_list'] = $jsonObj;
	
	mysqli_free_result($result);
	$jsonObj = array();
	$data_arr = array();

	$sql = "SELECT * FROM tbl_podcast WHERE tbl_podcast.`podcast_name` like '%$search_text%' AND tbl_podcast.`status`=1  ORDER BY tbl_podcast.`podcast_name` DESC";
	$result = mysqli_query($mysqli, $sql);
	while ($data = mysqli_fetch_assoc($result)){
	    
	    $data_arr['post_id'] = $data['pid'];
        $data_arr['post_title'] = $data['podcast_name'];
        $data_arr['post_image'] = $file_path.'images/'.$data['podcast_image'];
        
		array_push($jsonObj, $data_arr);
	}
	$row['podcasts_list'] = $jsonObj;
	
    $set[$API_NAME] = $row;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}

else if($get_helper['helper_name']=="favourite_post"){
    
    $response=array();
    $jsonObj= array();	
	
	$user_id = cleanInput($get_helper['user_id']);
	$post_id = cleanInput($get_helper['post_id']);

    $sql="SELECT * FROM tbl_favourite WHERE `post_id`='$post_id' AND `user_id`='$user_id'";
	$res=mysqli_query($mysqli, $sql);

	if(mysqli_num_rows($res) == 0){
		
		$data = array(
            'post_id'  =>  $post_id,
            'user_id'  =>  $user_id,
            'type'  =>  'radio',
            'created_at'  =>  strtotime(date('d-m-Y h:i:s A')), 
        );
        $qry = Insert('tbl_favourite',$data);
        
        $response=array('MSG' => $app_lang['favourite_success'],'success'=>'1');
	} else {
        
        $deleteSql="DELETE FROM tbl_favourite WHERE `post_id`='$post_id' AND `user_id`='$user_id'";
        if(mysqli_query($mysqli, $deleteSql)){
            $response=array('MSG' => $app_lang['favourite_remove_success'],'success'=>'0');
        } else{
            $response=array('MSG' => $app_lang['favourite_remove_error'],'success'=>'1');
        }
	}
	$set[$API_NAME][]=$response;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="get_favourite"){
    $jsonObj= array();	
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;
    
    $page_limit=10;
    $limit=($get_helper['page']-1) * $page_limit;

    $query="SELECT tbl_radio.*, tbl_category.* FROM tbl_radio
		LEFT JOIN tbl_favourite ON tbl_radio.`id`= tbl_favourite.`post_id`
		LEFT JOIN tbl_category ON tbl_radio.`cat_id`=tbl_category.`cid` 
		WHERE tbl_radio.`status`='1' AND tbl_category.`status`='1' AND tbl_favourite.`user_id`='$user_id' ORDER BY tbl_favourite.`id` DESC LIMIT $limit, $page_limit";
    	
	$sql = mysqli_query($mysqli,$query)or die(mysqli_error());
	while($data = mysqli_fetch_assoc($sql)){
	    $row['id'] = $data['id'];
        $row['cat_id'] = $data['cat_id'];
        $row['radio_title'] = $data['radio_title'];
        $row['radio_url'] = $data['radio_url'];
        $row['image'] = $file_path.'images/'.$data['radio_image'];
        $row['averageRating'] = $data['rate_avg'];
        $row['totalRate'] = $data['total_rate'];
        $row['category_name'] = $data['category_name'];
        $row['total_views'] = $data['total_views'];
        $row['is_premium'] = $data['isPremium'];
        $row['is_favourite'] =  is_favourite($data['id'],$user_id);
        
		array_push($jsonObj,$row);
	}
	$set[$API_NAME] = $jsonObj;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}

else if($get_helper['helper_name']=="post_report"){
    
    $jsonObj= array();
    $post_id=cleanInput($get_helper['post_id']);
	$user_id=cleanInput($get_helper['user_id']);
	$report_title=cleanInput($get_helper['report_title']);
	$report_msg=cleanInput($get_helper['report_msg']);
    
	$data = array(
        'post_id'  =>  $post_id,
        'user_id'  =>  $user_id,
        'report_title'  =>  $report_title,
        'report_msg'  =>  $report_msg,
        'report_on'  =>  strtotime(date('d-m-Y h:i:s A')), 
    );
    $qry = Insert('tbl_reports',$data);
    
    $data_not = array(
        'user_id' => $user_id,
        'notification_title' => 'Report successful',
        'notification_msg' => $report_msg,
        'notification_on' =>  strtotime(date('d-m-Y h:i:s A')) 
    );
    
    $qry2 = Insert('tbl_notification',$data_not);
    
	$set[$API_NAME][]=array('MSG'=> $app_lang['report_success'],'success'=> '1');
  	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="post_suggest"){	
    
	$user_id=cleanInput($get_helper['user_id']);
	$suggest_title=cleanInput($get_helper['suggest_title']);
	$suggest_message=cleanInput($get_helper['suggest_message']);
    	
	if($_FILES['image_data']['name']!=""){
		$image_data=rand(0,99999)."_".$_FILES['image_data']['name'];
		
        //Main Image
        $tpath1='images/'.$image_data;        
        $pic1=compress_image($_FILES["image_data"]["tmp_name"], $tpath1, 80);
	} else {
	    $image_data = '';
	}
	
	$data = array(
        'user_id'  =>  $user_id,
        'suggest_title'  =>  $suggest_title,
        'suggest_image'  =>  $image_data,
        'suggest_message'  =>  $suggest_message,
        'suggest_on'  =>  strtotime(date('d-m-Y h:i:s A')), 
    );
    $qry = Insert('tbl_suggest',$data);
    
    $data_not = array(
        'user_id' => $user_id,
        'notification_title' => 'Suggest successfully',
        'notification_msg' => $suggest_message,
        'notification_on' =>  strtotime(date('d-m-Y h:i:s A')) 
    );
    
    $qry2 = Insert('tbl_notification',$data_not);

    $set[$API_NAME][]=array('MSG'=> $app_lang['suggest_success'],'success'=> '1');
  	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="get_rating"){
    
    $jsonObj= array();	
    
    $post_id = cleanInput($get_helper['post_id']);
	$device_id = cleanInput($get_helper['device_id']);
	
	$result = mysqli_query($mysqli,"SELECT * FROM tbl_rating WHERE `post_id` = '$post_id' AND `device_id` = '$device_id'"); 
    if(mysqli_num_rows($result) > 0){
		$data = mysqli_fetch_assoc($result);
		$jsonObj = array( 'total_rate' => $data['rate'] , 'message' => $data['message']);	
	} else {
		$jsonObj = array( 'total_rate' => 0, 'message' => '');
	}
	
	$set[$API_NAME][] = $jsonObj;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="post_rating"){
    
    $jsonObj= array();	
    
    $post_id = cleanInput($get_helper['post_id']);
    $device_id = cleanInput($get_helper['device_id']);
    $therate = cleanInput($get_helper['rate']);
    $message = cleanInput($get_helper['message']);
    
    $result = mysqli_query($mysqli,"SELECT * FROM tbl_rating WHERE `post_id` = '$post_id' AND `device_id` = '$device_id'");
    
    if(mysqli_num_rows($result) == 0){
        
        $data = array(   
            'post_id' => $post_id,
            'device_id' => $device_id,
            'rate' => $therate,
            'message' => addslashes($message)
        );  
        $qry = Insert('tbl_rating',$data); 
        
        $query = mysqli_query($mysqli,"SELECT * FROM tbl_rating WHERE `post_id` = '$post_id'");
        
        while($data = mysqli_fetch_assoc($query)){
            $rate_db[] = $data;
            $sum_rates[] = $data['rate'];
        }
        
        if(@count($rate_db)){
            $rate_times = count($rate_db);
            $sum_rates = array_sum($sum_rates);
            $rate_value = $sum_rates/$rate_times;
            $rate_bg = (($rate_value)/5)*100;
        } else {
            $rate_times = 0;
            $rate_value = 0;
            $rate_bg = 0;
        }
        
        $rate_avg=round($rate_value); 
        
        $sql="UPDATE tbl_radio SET `total_rate` = `total_rate` + 1, `rate_avg` = '$rate_avg' where id='$post_id'";
        mysqli_query($mysqli,$sql);
        
        $total_rat_sql="SELECT * FROM tbl_radio WHERE id='".$post_id."'";
        $total_rat_res=mysqli_query($mysqli,$total_rat_sql);
        $total_rat_row=mysqli_fetch_assoc($total_rat_res);
        
        $jsonObj = array('total_rate' => $total_rat_row['total_rate'],'rate_avg' => $total_rat_row['rate_avg'],'MSG' => $app_lang['rate_success'],'success'=> '1');
    } else {
        $jsonObj = array('MSG' => $app_lang['rate_already'],'success'=> '0');
    }
    $set[$API_NAME][] = $jsonObj;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
// User
else if($get_helper['helper_name']=="user_register"){
    
    $user_type=isset($get_helper['type']) ? trim($get_helper['type']) : '';

    $email=isset($get_helper['user_email']) ? addslashes(trim($get_helper['user_email'])) : '';
    $auth_id=isset($get_helper['auth_id']) ? addslashes(trim($get_helper['auth_id'])) : '';

    $to=isset($get_helper['user_email']) ? $get_helper['user_email'] : '';
    $recipient_name=isset($get_helper['user_name']) ? $get_helper['user_name'] : '';

	$subject = str_replace('###', APP_NAME, $app_lang['register_mail_lbl']);

	$response=array();

	$user_id='';
	
    switch ($user_type) {
        case 'Google':
        {
            $sql="SELECT * FROM tbl_users WHERE (`user_email` = '$email' OR `auth_id`='$auth_id') AND `user_type`='Google'";
            $res=mysqli_query($mysqli,$sql);
            if(mysqli_num_rows($res) == 0){
                
                $data = [
                    'user_type'=>'Google',
                    'user_name' => addslashes(trim($get_helper['user_name'])),
                    'user_email' => addslashes(trim($get_helper['user_email'])),
                    'user_phone' => '',
                    'user_password' => md5(DEFAULT_PASSWORD),
                    'user_gender'  => '',
                    'registered_on'  =>  strtotime(date('d-m-Y h:i:s A')),
                    'auth_id' => $auth_id,
                    'profile_img' => '',
                    'status'  =>  '1'
                ];
                
                $qry = Insert('tbl_users',$data);
                
                $user_id=mysqli_insert_id($mysqli);
                send_register_email($to, $recipient_name, $subject, $app_lang['google_register_msg']);
                
                // login success
                $response = array('user_id' =>  strval($user_id), 'user_name'=> $get_helper['user_name'], 'user_email'=> $get_helper['user_email'], 'user_phone'=> '', 'user_gender'=> '', 'profile_img'=> '', 'auth_id' => $auth_id, 'MSG' => $app_lang['login_success'], 'success'=>'1');
            }
            else {
                
                $row = mysqli_fetch_assoc($res);
                
                $data = array('auth_id'  =>  $auth_id); 
                $update=Update('tbl_users', $data, "WHERE id = '".$row['id']."'");
                
                $user_id=$row['id'];
                
                if($row['status']==0){
                    $response=array('msg' =>$app_lang['account_deactive'],'success'=>'0');
                } else {
                    $response = array('user_id' =>  $row['id'],'user_name'=> $row['user_name'],'user_email'=> $row['user_email'],'user_phone'=> $row['user_phone'],'user_gender'=> $row['user_gender'],'profile_img'=> $row['profile_img'],'auth_id' => $auth_id,'MSG' => $app_lang['login_success'],'success'=> '1');
                }
            }
            update_activity_log($user_id);
        }
        break;
        case 'Normal':
        {
            $sql = "SELECT * FROM tbl_users WHERE user_email = '$email'"; 
            $result = mysqli_query($mysqli, $sql);
            $row = mysqli_fetch_assoc($result);
            
            if (!filter_var($get_helper['user_email'], FILTER_VALIDATE_EMAIL)) {
                $response=array('MSG' => $app_lang['invalid_email_format'],'success'=>'0');
            }
            else if($row['user_email']!="") {
                $response=array('MSG' => $app_lang['email_exist'],'success'=>'0');
            }
            else {
                
                if($_FILES['image_data']['name']!="") {
                    
                    $imgName=rand(0,99999)."_".$_FILES['image_data']['name'];
                    //Main Image
                    $tpath1='images/'.$imgName;        
                    $pic1=compress_image($_FILES["image_data"]["tmp_name"], $tpath1, 80);
                    
                } else {
                    $imgName = '';
                }
                
                $data = [
                    'user_name' => addslashes(trim($get_helper['user_name'])),
                    'user_email' => addslashes(trim($get_helper['user_email'])),
                    'user_phone' => addslashes(trim($get_helper['user_phone'])),
                    'user_password' => md5(trim($get_helper['user_password'])),
                    'user_gender'  => addslashes(trim($get_helper['user_gender'])),
                    'registered_on'  =>  strtotime(date('d-m-Y h:i:s A')),
                    'profile_img' => $imgName,
                    'status'  =>  '1'
                ];
                
                $qry = Insert('tbl_users',$data);
                
                $user_id=mysqli_insert_id($mysqli);
                
                send_register_email($to, $recipient_name, $subject, $app_lang['normal_register_msg']);
                
                $response=array('MSG' => $app_lang['register_success'],'success'=>'1');
                
                update_activity_log($user_id);
            }
        }
        break;
        default:
        {
            $response=array('success'=>'0', 'MSG' =>$app_lang['register_fail']);
        }
        break;
    }
	$set[$API_NAME][]=$response;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="user_login"){
    
    $response=array();

    $email=isset($get_helper['user_email']) ? trim($get_helper['user_email']) : '';
    $password=isset($get_helper['user_password']) ? trim($get_helper['user_password']) : '';
    $auth_id=isset($get_helper['auth_id']) ? trim($get_helper['auth_id']) : '';
    $user_type=isset($get_helper['type']) ? trim($get_helper['type']) : '';
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL) AND $email!='') {
        $response=array('MSG' => $app_lang['invalid_email_format'],'success'=>'0');
        $set[$API_NAME][]=$response;
        header( 'Content-Type: application/json; charset=utf-8' );
        echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        die();
    }
    
    switch ($user_type) {
        case 'Google':
        {
            $sql = "SELECT * FROM tbl_users WHERE (`user_email` = '$email' OR `auth_id`='$auth_id') AND (`user_type`='Google' OR `user_type`='google')";
            $res=mysqli_query($mysqli, $sql);
            if(mysqli_num_rows($res) > 0) {
                $row = mysqli_fetch_assoc($res);
                if($row['status']==0) {
                    $response=array('MSG' => $app_lang['account_deactive'],'success'=>'0');
                } else {
                    $user_id=$row['id'];
                    
                    update_activity_log($user_id);
                    
                    $data = array('auth_id'  =>  $auth_id);  
                    
                    Update('tbl_users', $data, "WHERE `id` = ".$row['id']);
                    
                    $response = array('user_id' =>  $row['id'],'user_name'=> $row['user_name'],'user_phone'=> $row['user_phone'],'user_gender'=> $row['user_gender'],'profile_img'=> $file_path.'images/'.$row['profile_img'],'MSG' => $app_lang['login_success'],'success'=>'1');
                }
            }
            else {
                $response=array('MSG' => $app_lang['email_not_found'],'success'=>'0');
            }
        }
        break;
        case 'Normal':
        {
            $qry = "SELECT * FROM tbl_users WHERE user_email = '$email' AND (`user_type`='Normal' OR `user_type`='normal') AND `id` <> 0"; 
            $result = mysqli_query($mysqli,$qry);
            $num_rows = mysqli_num_rows($result);
            if($num_rows > 0) {
                $row = mysqli_fetch_assoc($result);
                if($row['status']==1) {
                    if($row['user_password']==md5($password)) {
                        
                        $user_id=$row['id'];
                        
                        update_activity_log($user_id);
                        
                        $response = array('user_id' =>  $row['id'],'user_name'=> $row['user_name'],'user_phone'=> $row['user_phone'],'user_gender'=> $row['user_gender'],'profile_img'=> $file_path.'images/'.$row['profile_img'],'MSG' => $app_lang['login_success'],'success'=>'1'); 
                    }
                    else{
                        $response=array('MSG' =>$app_lang['invalid_password'],'success'=>'0');
                    }
                }
                else {
                    $response=array('MSG' =>$app_lang['account_deactive'],'success'=>'0');
                }
            }
            else {
                $response=array('MSG' =>$app_lang['email_not_found'],'success'=>'0');	
            }
        }
        break;
        default:
        {
            $response=array('success'=>'0', 'MSG' =>$app_lang['register_fail']);
        }
        break;
    }
    $set[$API_NAME][]=$response;
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name'] == "user_profile") {
	$jsonObj= array();	
	
	$user_id=cleanInput($get_helper['user_id']);

	$qry = "SELECT * FROM tbl_users WHERE id = '$user_id'"; 
	$result = mysqli_query($mysqli,$qry);
	$row = mysqli_fetch_assoc($result);	
	
	$data['success']="1";
	$data['user_id'] = $row['id'];
	$data['user_name'] = $row['user_name'];
	$data['user_email'] = ($row['user_email']!='') ? $row['user_email'] : '';
	$data['user_phone'] = ($row['user_phone']!='') ? $row['user_phone'] : '';
	$data['user_gender'] = $row['user_gender'];
	$data['profile_img'] = $file_path.'images/'.$row['profile_img'];

	array_push($jsonObj,$data);

    $set[$API_NAME] = $jsonObj;
	header( 'Content-Type: application/json; charset=utf-8' );
	echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE));
	die();
}
else if($get_helper['helper_name']=="edit_profile"){
    
    $jsonObj= array();	
	
	$qry = "SELECT * FROM tbl_users WHERE id = '".$get_helper['user_id']."'"; 
	$result = mysqli_query($mysqli,$qry);
	$row = mysqli_fetch_assoc($result);
  
  	if (!filter_var($get_helper['user_email'], FILTER_VALIDATE_EMAIL)) {
  	    $set[$API_NAME][]=array('MSG' => $app_lang['invalid_user_type'],'success'=>'0');
	}
	else if($row['user_email']==$get_helper['user_email'] AND $row['id']!=$get_helper['user_id']) {
        $set[$API_NAME][]=array('MSG' => $app_lang['email_not_found'],'success'=>'0');
	} 
	else {
        $data = array(
            'user_name'  =>  cleanInput($get_helper['user_name']),
            'user_email'  =>  trim($get_helper['user_email']),
            'user_phone'  =>  cleanInput($get_helper['user_phone']),
		);
		
		if($get_helper['user_password']!=""){
			$data = array_merge($data, array("user_password" => md5(trim($get_helper['user_password']))));
		}
		
		$user_edit=Update('tbl_users', $data, "WHERE id = '".$get_helper['user_id']."'");
		
		$set[$API_NAME][] = array('MSG' => $app_lang['update_success'], 'success' => '1');
	}
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}
else if($get_helper['helper_name']=="user_images_update"){	
    
	if($_FILES['image_data']['name']!="") {
	    
		$image_data=rand(0,99999)."_".$_FILES['image_data']['name'];
        //Main Image
        $tpath1='images/'.$image_data;        
        $pic1=compress_image_app($_FILES["image_data"]["tmp_name"], $tpath1, 80);
        
        $data = array('profile_img'  =>  $image_data);
        $user_update =Update('tbl_users', $data, "WHERE id = '".$get_helper['user_id']."'");
        
        $set[$API_NAME][]=array('MSG'=> $app_lang['update_success'],'success' => '1');
	} else {
        $set[$API_NAME][]=array('MSG' => "Update error",'success' => '0');
	}
  	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="account_delete"){
    
    $ids = cleanInput($get_helper['user_id']);
    
    $sql="SELECT * FROM tbl_users WHERE `id`='$ids'";
    $res=mysqli_query($mysqli, $sql);
    if(mysqli_num_rows($res) > 0) {
        
        $sql_img="SELECT * FROM tbl_users WHERE `id` IN ($ids)";
        $res_img=mysqli_query($mysqli, $sql_img);
        while ($row=mysqli_fetch_assoc($res_img)) {
            if($row['profile_img']!="") {
                unlink('images/'.$row['profile_img']);
            }
        }
        
        $deleteSql = "DELETE FROM tbl_active_log WHERE `user_id` IN ($ids)";
        mysqli_query($mysqli, $deleteSql);
        
        $deleteSql="DELETE FROM tbl_notification WHERE `user_id` IN ($ids)";
        mysqli_query($mysqli, $deleteSql);
        
        $deleteSql = "DELETE FROM tbl_users WHERE `id` IN ($ids)";
        mysqli_query($mysqli, $deleteSql);
        
        $set[$API_NAME][]=array('MSG'=> "Remove success",'success'=> '1');
    } else {
        $set[$API_NAME][]=array('MSG'=> 'Remove error','success'=> '0');
    }
    header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    die();
}

else if($get_helper['helper_name']=="forgot_pass"){
    
    $email=addslashes(trim($get_helper['user_email']));

	$qry = "SELECT * FROM tbl_users WHERE user_email = '$email' AND `user_type`='Normal' AND `id` <> 0"; 
	$result = mysqli_query($mysqli,$qry);
	$row = mysqli_fetch_assoc($result);
	
	if($row['user_email']!="") {
		$password=generateRandomPassword(7);
		
		$new_password=md5($password);
		$to = $row['user_email'];
		$recipient_name=$row['user_name'];
		
		// subject
		$subject = str_replace('###', APP_NAME, $app_lang['forgot_password_sub_lbl']);
		$message='<div style="background-color: #f9f9f9;" align="center"><br />
				  <table style="font-family: OpenSans,sans-serif; color: #666666;" border="0" width="600" cellspacing="0" cellpadding="0" align="center" bgcolor="#FFFFFF">
				    <tbody>
				      <tr>
				        <td colspan="2" bgcolor="#FFFFFF" align="center"><img src="'.$file_path.'images/'.APP_LOGO.'" alt="header" style="width:100px;height:auto"/></td>
				      </tr>
				      <tr>
				        <td width="600" valign="top" bgcolor="#FFFFFF"><br>
				          <table style="font-family:OpenSans,sans-serif; color: #666666; font-size: 10px; padding: 15px;" border="0" width="100%" cellspacing="0" cellpadding="0" align="left">
				            <tbody>
				              <tr>
				                <td valign="top"><table border="0" align="left" cellpadding="0" cellspacing="0" style="font-family:OpenSans,sans-serif; color: #666666; font-size: 10px; width:100%;">
				                    <tbody>
				                      <tr>
				                        <td>
				                          <p style="color: #262626; font-size: 24px; margin-top:0px;"><strong>'.$app_lang['dear_lbl'].' '.$row['user_name'].'</strong></p>
				                          <p style="color:#262626; font-size:20px; line-height:32px;font-weight:500;margin-top:5px;"><br>'.$app_lang['your_password_lbl'].': <span style="font-weight:400;">'.$password.'</span></p>
				                          <p style="color:#262626; font-size:17px; line-height:32px;font-weight:500;margin-bottom:30px;">'.$app_lang['thank_you_lbl'].' '.APP_NAME.'</p>
				                          
				                        </td>
				                      </tr>
				                    </tbody>
				                  </table></td>
				              </tr>
				               
				            </tbody>
				          </table></td>
				      </tr>
				      <tr>
				        <td style="color: #262626; padding: 20px 0; font-size: 18px; border-top:5px solid #52bfd3;" colspan="2" align="center" bgcolor="#ffffff">'.$app_lang['email_copyright'].' '.APP_NAME.'.</td>
				      </tr>
				    </tbody>
				  </table>
				</div>';
				
		send_email($to,$recipient_name,$subject,$message);
		
		$sql="UPDATE tbl_users SET `user_password`='$new_password' WHERE `id`='".$row['id']."'";
      	mysqli_query($mysqli,$sql);
		 	  
		$set[$API_NAME][]=array('MSG' => $app_lang['password_sent_mail'],'success'=>'1');
	}
	else {  	 
		$set[$API_NAME][]=array('MSG' => $app_lang['email_not_found'],'success'=>'0');
	}
	header( 'Content-Type: application/json; charset=utf-8' );
	echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE));
	die();
}
else if($get_helper['helper_name']=="get_notification") {
    
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;

    $jsonObj= array();
    
	$page_limit=50;
	$limit=($get_helper['page']-1) * $page_limit;

    $query="SELECT * FROM tbl_notification WHERE `user_id`='$user_id' ORDER BY tbl_notification.`id` DESC LIMIT $limit, $page_limit"; 
	$sql = mysqli_query($mysqli,$query)or die(mysqli_error($mysqli));
	while($data = mysqli_fetch_assoc($sql)){
		$row['id'] = $data['id'];
      	$row['notification_title'] = $data['notification_title'];
      	$row['notification_msg'] = $data['notification_msg']; 
		$row['notification_on'] = calculate_time_span($data['notification_on'],true);		 
		array_push($jsonObj,$row);
	}
	$set[$API_NAME] = $jsonObj;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else if($get_helper['helper_name']=="remove_notification"){
    
    $post_id=isset($get_helper['post_id']) ? cleanInput($get_helper['post_id']) : 0;
    $user_id=isset($get_helper['user_id']) ? cleanInput($get_helper['user_id']) : 0;

	$jsonObj= array();
	
	$sql="SELECT * FROM tbl_notification WHERE `id`='$post_id' AND `user_id`='$user_id'";
	$res=mysqli_query($mysqli, $sql);
	if(mysqli_num_rows($res) > 0) {
		$deleteSql="DELETE FROM tbl_notification WHERE `id`='$post_id' AND `user_id`='$user_id'";
		mysqli_query($mysqli, $deleteSql);
		
        $set[$API_NAME][]=array('MSG'=> $app_lang['remove_success'],'success'=> '1');
	} else {
	    $set[$API_NAME][]=array('MSG'=> $app_lang['like_remove_error'],'success'=> '0');
	}
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
// App details
else if($get_helper['helper_name']=="app_details"){

    $jsonObj= array();	
	$query="SELECT * FROM tbl_settings WHERE id='1'";
	$sql = mysqli_query($mysqli,$query);
	
	while($data = mysqli_fetch_assoc($sql)){
	    
        // App Details
        $row['app_email'] = $data['app_email'];
        $row['app_author'] = $data['app_author'];
        $row['app_contact'] = $data['app_contact'];
        $row['app_website'] = $data['app_website'];
        $row['app_description'] = $data['app_description'];
        $row['app_developed_by'] = $data['app_developed_by'];
        
        // Envato
        $row['envato_api_key'] = $data['envato_api_key'];
        
        // API Latest Limit
        $row['api_latest_limit'] = $data['api_latest_limit'];
        
        // Ads Network
        $row['ad_network'] = $data['ad_network'];
        
        $row['publisher_id'] = ($data['ad_network'] == 'admob') ? $row['publisher_id'] : "";
        $row['startapp_app_id'] = ($data['ad_network'] == 'startapp') ? $row['start_ads_id'] : "";
        $row['iron_ads_id'] = ($data['ad_network'] == 'iron') ? $row['iron_ads_id'] : "";
        $row['wortise_app_id'] = ($data['ad_network'] == 'wortise') ? $row['wortise_app_id'] : "";
        
        // BannerAds
        $row['banner_ad'] = $data['banner_ad'];
        if ($data['ad_network'] == 'facebook') {
            $row['banner_ad_id'] = $data['banner_facebook_id'];
        } else if ($data['ad_network'] == 'admob') {
            $row['banner_ad_id'] = $data['banner_ad_id'];
        } else if ($data['ad_network'] == 'applovins') {
            $row['banner_ad_id'] = $data['banner_applovins_id'];
        } else if ($data['ad_network'] == 'wortise') {
            $row['banner_ad_id'] = $data['banner_wortise_id'];
        } else {
            $row['banner_ad_id'] = '';
        }
       
        // InterstitalAds
        $row['interstital_ad'] = $data['interstital_ad'];
        $row['interstital_ad_click'] = $data['interstital_ad_click'];
        if ($data['ad_network'] == 'facebook') {
            $row['interstital_ad_id'] = $data['interstital_facebook_id'];
        } else if ($data['ad_network'] == 'admob') {
            $row['interstital_ad_id'] = $data['interstital_ad_id'];
        } else if ($data['ad_network'] == 'applovins') {
            $row['interstital_ad_id'] = $data['interstital_applovins_id'];
        } else if ($data['ad_network'] == 'wortise') {
            $row['interstital_ad_id'] = $data['interstital_wortise_id'];
        } else {
            $row['interstital_ad_id'] = '';
        }
        
        // NativeAds
        $row['native_ad'] = $data['native_ad'];
        $row['native_position'] = $data['native_position'];
        if ($data['ad_network'] == 'facebook') {
            $row['native_ad_id'] = $data['native_facebook_id'];
        } else if ($data['ad_network'] == 'admob') {
            $row['native_ad_id'] = $data['native_ad_id'];
        } else if ($data['ad_network'] == 'applovins') {
            $row['native_ad_id'] = $data['native_applovins_id'];
        } else if ($data['ad_network'] == 'wortise') {
            $row['native_ad_id'] = $data['native_wortise_id'];
        } else {
            $row['native_ad_id'] = '';
        }
        
        // CustomAds
        $row['custom_ads'] = $data['custom_ads'];
        $row['custom_ads_img'] = $data['custom_ads_img'];
        $row['custom_ads_link'] = $data['custom_ads_link'];
        $row['custom_ads_clicks'] = $data['custom_ads_clicks'];
        
        // is
        $row['isRTL'] = $data['isRTL'];
        $row['isMaintenance'] = $data['isMaintenance'];
        $row['isScreenshot'] = $data['isScreenshot'];
        $row['isGoogleLogin'] = $data['isGoogleLogin'];
        $row['isLogin'] = $data['isLogin'];
        $row['isAPK'] = $data['isAPK'];
        $row['isVPN'] = $data['isVPN'];
        
        $row['isDummy_1'] = $data['isDummy_1'];
        $row['isDummy_2'] = $data['isDummy_2'];
        $row['dummy_test_1'] = $data['dummy_test_1'];
        $row['dummy_test_2'] = $data['dummy_test_2'];
       
        // AppUpdate
        $row['app_update_status'] = $data['app_update_status'];
        $row['app_new_version'] = $data['app_new_version'];
        $row['app_update_desc'] = $data['app_update_desc'];
        $row['app_redirect_url'] = $data['app_redirect_url'];
        
        array_push($jsonObj,$row);
    }
	$set[$API_NAME] = $jsonObj;
	header( 'Content-Type: application/json; charset=utf-8' );
    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
}
else {
    $get_helper = get_api_data($_POST['data']);
}